## @file
# platform build option configuration file.
#
# @copyright
#  INTEL CONFIDENTIAL
#  Copyright 2014 - 2018 Intel Corporation.
#
#  The source code contained or described herein and all documents related to the
#  source code ("Material") are owned by Intel Corporation or its suppliers or
#  licensors. Title to the Material remains with Intel Corporation or its suppliers
#  and licensors. The Material may contain trade secrets and proprietary and
#  confidential information of Intel Corporation and its suppliers and licensors,
#  and is protected by worldwide copyright and trade secret laws and treaty
#  provisions. No part of the Material may be used, copied, reproduced, modified,
#  published, uploaded, posted, transmitted, distributed, or disclosed in any way
#  without Intel's prior express written permission.
#
#  No license under any patent, copyright, trade secret or other intellectual
#  property right is granted to or conferred upon you by disclosure or delivery
#  of the Materials, either expressly, by implication, inducement, estoppel or
#  otherwise. Any license under such intellectual property rights must be
#  express and approved by Intel in writing.
#
#  Unless otherwise agreed by Intel in writing, you may not remove or alter
#  this notice or any other notice embedded in Materials by Intel or
#  Intel's suppliers or licensors in any way.
#
#  This file contains a 'Sample Driver' and is licensed as such under the terms
#  of your license agreement with Intel or your vendor. This file may be modified
#  by the user, subject to the additional terms of the license agreement.
#
# @par Specification
##

[BuildOptions]
# Define Build Options both for EDK and EDKII drivers.

!if gSiPkgTokenSpaceGuid.PcdSourceDebugEnable == TRUE
  *_*_X64_GENFW_FLAGS  = --keepexceptiontable
!endif

!if gSiPkgTokenSpaceGuid.PcdS3Enable == TRUE
  DEFINE DSC_S3_BUILD_OPTIONS = -DEFI_S3_RESUME
!else
  DEFINE DSC_S3_BUILD_OPTIONS =
!endif

!if gSiPkgTokenSpaceGuid.PcdSiCsmEnable == TRUE
  DEFINE DSC_CSM_BUILD_OPTIONS = -DCSM_FLAG=1
!else
  DEFINE DSC_CSM_BUILD_OPTIONS =
!endif

!if gSiPkgTokenSpaceGuid.PcdAcpiEnable == TRUE
  DEFINE DSC_ACPI_BUILD_OPTIONS = -DACPI_SUPPORT=1
!else
  DEFINE DSC_ACPI_BUILD_OPTIONS =
!endif

!if gSiPkgTokenSpaceGuid.PcdBiosGuardEnable == TRUE
  DEFINE BIOS_GUARD_BUILD_OPTIONS = -DBIOS_GUARD_SUPPORT_FLAG=1
!else
  DEFINE BIOS_GUARD_BUILD_OPTIONS =
!endif

!if gSiPkgTokenSpaceGuid.PcdOverclockEnable == TRUE
  DEFINE OVERCLOCKING_BUILD_OPTION = -DOVERCLOCK_FLAG=1
!else
  DEFINE OVERCLOCKING_BUILD_OPTION =
!endif

!if gPlatformModuleTokenSpaceGuid.PcdFspBinaryEnable == TRUE
!ifdef $(FSP_PACKAGE)
  DEFINE FSP_BINARY_BUILD_OPTIONS = -DFSP_FLAG
!else
  DEFINE FSP_BINARY_BUILD_OPTIONS =
!endif
!else
  DEFINE FSP_BINARY_BUILD_OPTIONS =
!endif

!if gPlatformModuleTokenSpaceGuid.PcdFspWrapperEnable == TRUE
  DEFINE FSP_WRAPPER_BUILD_OPTIONS = -DFSP_WRAPPER_FLAG
!else
  DEFINE FSP_WRAPPER_BUILD_OPTIONS =
!endif

!if gPlatformModuleTokenSpaceGuid.PcdSkipFspTempRamInitAndExit == TRUE
  DEFINE SKIP_FSP_TEMPRAM_INIT_AND_EXIT_OPTIONS = -DSKIP_FSP_TEMPRAM_INIT_AND_EXIT
!else
  DEFINE SKIP_FSP_TEMPRAM_INIT_AND_EXIT_OPTIONS =
!endif

  DEFINE RESTRICTED_OPTION =

  DEFINE SV_BUILD_OPTIONS =

  DEFINE TEST_MENU_BUILD_OPTION =

!if gSiPkgTokenSpaceGuid.PcdOptimizeCompilerEnable == FALSE
  DEFINE OPTIMIZE_DISABLE_OPTIONS = -Od -GL-
!else
  DEFINE OPTIMIZE_DISABLE_OPTIONS =
!endif

!if gPlatformModuleTokenSpaceGuid.PcdUpServerEnable == TRUE
  DEFINE UP_SERVER_SUPPORT_BUILD_OPTIONS = -DUP_SERVER_FLAG=1
!else
  DEFINE UP_SERVER_SUPPORT_BUILD_OPTIONS =
!endif

!if gSiPkgTokenSpaceGuid.PcdTxtEnable == TRUE
!endif

!if gPlatformModuleTokenSpaceGuid.PcdTpmEnable == TRUE
  DEFINE TPM_BUILD_OPTION = -DTPM_FLAG=1
!else
  DEFINE TPM_BUILD_OPTION =
!endif

!if gPlatformModuleTokenSpaceGuid.PcdTpm2Enable == TRUE
  DEFINE TPM2_BUILD_OPTION = -DTPM2_FLAG=1
!else
  DEFINE TPM2_BUILD_OPTION =
!endif

!if gPlatformModuleTokenSpaceGuid.PcdTbtEnable == TRUE
  DEFINE DSC_TBT_BUILD_OPTIONS = -DTBT_FLAG=1
!else
  DEFINE DSC_TBT_BUILD_OPTIONS =
!endif

!if gPlatformModuleTokenSpaceGuid.PcdDcttFlagEnable == TRUE
  DEFINE DSC_DCTT_BUILD_OPTIONS = -DDCTT_FLAG=1
!else
  DEFINE DSC_DCTT_BUILD_OPTIONS =
!endif

!if gPlatformModuleTokenSpaceGuid.PcdEmbeddedEnable == TRUE
  DEFINE EMB_BUILD_OPTIONS = -DEMBEDDED_FLAG=1
!else
  DEFINE EMB_BUILD_OPTIONS =
!endif

!if gPlatformModuleTokenSpaceGuid.PcdMemoryDownEnable == TRUE
  DEFINE DSC_MEMORY_DOWN_BUILD_OPTIONS = -DMEM_DOWN_FLAG=1
!else
  DEFINE DSC_MEMORY_DOWN_BUILD_OPTIONS =
!endif

  DEFINE DSC_KBCEMUL_BUILD_OPTIONS =

!if gSiPkgTokenSpaceGuid.PcdBootGuardEnable == TRUE
  DEFINE BOOT_GUARD_BUILD_OPTIONS = -DBOOT_GUARD_SUPPORT_FLAG=1
!else
  DEFINE BOOT_GUARD_BUILD_OPTIONS =
!endif

!if gPlatformModuleTokenSpaceGuid.PcdSecureBootEnable == TRUE
  DEFINE SECURE_BOOT_BUILD_OPTIONS = -DSECURE_BOOT_SUPPORT_FLAG=1
!else
  DEFINE SECURE_BOOT_BUILD_OPTIONS =
!endif

!if gPlatformModuleTokenSpaceGuid.PcdUsbTypeCEnable == TRUE
  DEFINE USBTYPEC_BUILD_OPTION = -DUSBTYPEC_FLAG=1
!else
  DEFINE USBTYPEC_BUILD_OPTION =
!endif

!if gPlatformModuleTokenSpaceGuid.PcdCapsuleEnable == TRUE
  DEFINE CAPSULE_BUILD_OPTIONS = -DCAPSULE_FLAG=1
!else
  DEFINE CAPSULE_BUILD_OPTIONS =
!endif

!if gPlatformModuleTokenSpaceGuid.PcdPerformanceEnable == TRUE
  DEFINE PERFORMANCE_BUILD_OPTION = -DPERFORMANCE_FLAG=1
!else
  DEFINE PERFORMANCE_BUILD_OPTION =
!endif

!if gPlatformModuleTokenSpaceGuid.PcdSourceDebugUseUsb == TRUE
  DEFINE DEBUGUSEUSB_BUILD_OPTION = -DDEBUGUSEUSB_FLAG=1
!else
  DEFINE DEBUGUSEUSB_BUILD_OPTION =
!endif

!if gPlatformModuleTokenSpaceGuid.PcdDeprecatedFunctionRemove == TRUE
  DEFINE DISABLE_NEW_DEPRECATED_INTERFACES_BUILD_OPTION = -DDISABLE_NEW_DEPRECATED_INTERFACES=1
!else
  DEFINE DISABLE_NEW_DEPRECATED_INTERFACES_BUILD_OPTION =
!endif

!if gPlatformModuleTokenSpaceGuid.PcdSinitAcmBinEnable == TRUE
  DEFINE SINITBIN_BUILD_OPTION = -DSINITBIN_FLAG=1
!else
  DEFINE SINITBIN_BUILD_OPTION =
!endif

!if gSiPkgTokenSpaceGuid.PcdMinTreeEnable == TRUE
  DEFINE MINTREE_FLAG_BUILD_OPTION = -DMINTREE_FLAG=1
!else
  DEFINE MINTREE_FLAG_BUILD_OPTION =
!endif

DEFINE DSC_PLTPKG_FEATURE_BUILD_OPTIONS = $(DSC_SIPKG_FEATURE_BUILD_OPTIONS)  $(OVERCLOCKING_BUILD_OPTION) $(PERFORMANCE_BUILD_OPTION) $(EMB_BUILD_OPTIONS) $(BIOS_GUARD_BUILD_OPTIONS) $(DSC_TBT_BUILD_OPTIONS)
DEFINE DSC_PLTPKG_FEATURE_BUILD_OPTIONS = $(DSC_PLTPKG_FEATURE_BUILD_OPTIONS) $(BOOT_GUARD_BUILD_OPTIONS) $(DSC_MEMORY_DOWN_BUILD_OPTIONS) $(DEBUGUSEUSB_BUILD_OPTION) $(DSC_S3_BUILD_OPTIONS)
DEFINE DSC_PLTPKG_FEATURE_BUILD_OPTIONS = $(DSC_PLTPKG_FEATURE_BUILD_OPTIONS) $(FSP_BINARY_BUILD_OPTIONS) $(FSP_WRAPPER_BUILD_OPTIONS) $(SKIP_FSP_TEMPRAM_INIT_AND_EXIT_OPTIONS)
DEFINE DSC_PLTPKG_FEATURE_BUILD_OPTIONS = $(DSC_PLTPKG_FEATURE_BUILD_OPTIONS) $(DSC_KBCEMUL_BUILD_OPTIONS) $(CAPSULE_BUILD_OPTIONS) $(SECURE_BOOT_BUILD_OPTIONS) $(DSC_CSM_BUILD_OPTIONS) $(DISABLE_NEW_DEPRECATED_INTERFACES_BUILD_OPTION)
DEFINE DSC_PLTPKG_FEATURE_BUILD_OPTIONS = $(DSC_PLTPKG_FEATURE_BUILD_OPTIONS) $(TPM2_BUILD_OPTION) $(TPM_BUILD_OPTION) $(DSC_DCTT_BUILD_OPTIONS)
DEFINE DSC_PLTPKG_FEATURE_BUILD_OPTIONS = $(DSC_PLTPKG_FEATURE_BUILD_OPTIONS) $(DSC_ACPI_BUILD_OPTIONS) $(UP_SERVER_SUPPORT_BUILD_OPTIONS) $(USBTYPEC_BUILD_OPTION) $(SINITBIN_BUILD_OPTION) $(MINTREE_FLAG_BUILD_OPTION)

[BuildOptions.Common.EDKII]
!if gPlatformModuleTokenSpaceGuid.PcdPerformanceEnable == TRUE
# todo why -DEBUG is set in RELEASE target. Does it for performnace tip to show the image name based on PDB file in EFI image?
  RELEASE_*_*_DLINK_FLAGS = -DEBUG
!endif

#
# For IA32 Global Build Flag
#
       *_*_IA32_CC_FLAGS      = $(DSC_PLTPKG_FEATURE_BUILD_OPTIONS) -D PI_SPECIFICATION_VERSION=0x00010015 -DASF_PEI
       *_*_IA32_VFRPP_FLAGS   = $(DSC_PLTPKG_FEATURE_BUILD_OPTIONS)
       *_*_IA32_APP_FLAGS     = $(DSC_PLTPKG_FEATURE_BUILD_OPTIONS)
       *_*_IA32_ASLPP_FLAGS   = $(DSC_PLTPKG_FEATURE_BUILD_OPTIONS)
       *_*_IA32_ASLCC_FLAGS   = $(DSC_PLTPKG_FEATURE_BUILD_OPTIONS)
       *_*_IA32_NASM_FLAGS    = $(DSC_PLTPKG_FEATURE_BUILD_OPTIONS)

#
# For IA32 Specific Build Flag
#
GCC:   *_*_IA32_PP_FLAGS      = $(DSC_PLTPKG_FEATURE_BUILD_OPTIONS)
MSFT:  *_*_IA32_ASM_FLAGS     = $(DSC_PLTPKG_FEATURE_BUILD_OPTIONS)
MSFT:  *_*_IA32_CC_FLAGS      = $(DSC_PLTPKG_FEATURE_BUILD_OPTIONS) $(OPTIMIZE_DISABLE_OPTIONS) -D PI_SPECIFICATION_VERSION=0x00010015 -DASF_PEI
MSFT:  *_*_IA32_VFRPP_FLAGS   = $(DSC_PLTPKG_FEATURE_BUILD_OPTIONS) $(OPTIMIZE_DISABLE_OPTIONS)
MSFT:  *_*_IA32_APP_FLAGS     = $(DSC_PLTPKG_FEATURE_BUILD_OPTIONS) $(OPTIMIZE_DISABLE_OPTIONS)
MSFT:  *_*_IA32_ASLPP_FLAGS   = $(DSC_PLTPKG_FEATURE_BUILD_OPTIONS) $(OPTIMIZE_DISABLE_OPTIONS)
MSFT:  *_*_IA32_ASLCC_FLAGS   = $(DSC_PLTPKG_FEATURE_BUILD_OPTIONS) $(OPTIMIZE_DISABLE_OPTIONS)

#
# For X64 Global Build Flag
#
       *_*_X64_CC_FLAGS       = $(DSC_PLTPKG_FEATURE_BUILD_OPTIONS) -D PI_SPECIFICATION_VERSION=0x00010015
       *_*_X64_VFRPP_FLAGS    = $(DSC_PLTPKG_FEATURE_BUILD_OPTIONS)
       *_*_X64_APP_FLAGS      = $(DSC_PLTPKG_FEATURE_BUILD_OPTIONS)
       *_*_X64_ASLPP_FLAGS    = $(DSC_PLTPKG_FEATURE_BUILD_OPTIONS)
       *_*_X64_ASLCC_FLAGS    = $(DSC_PLTPKG_FEATURE_BUILD_OPTIONS)
       *_*_X64_NASM_FLAGS     = $(DSC_PLTPKG_FEATURE_BUILD_OPTIONS)


#
# For X64 Specific Build Flag
#
GCC:   *_*_X64_PP_FLAGS       = $(DSC_PLTPKG_FEATURE_BUILD_OPTIONS)
MSFT:  *_*_X64_ASM_FLAGS      = $(DSC_PLTPKG_FEATURE_BUILD_OPTIONS)
MSFT:  *_*_X64_CC_FLAGS       = $(DSC_PLTPKG_FEATURE_BUILD_OPTIONS) $(OPTIMIZE_DISABLE_OPTIONS) -D PI_SPECIFICATION_VERSION=0x00010015
MSFT:  *_*_X64_VFRPP_FLAGS    = $(DSC_PLTPKG_FEATURE_BUILD_OPTIONS) $(OPTIMIZE_DISABLE_OPTIONS)
MSFT:  *_*_X64_APP_FLAGS      = $(DSC_PLTPKG_FEATURE_BUILD_OPTIONS) $(OPTIMIZE_DISABLE_OPTIONS)
MSFT:  *_*_X64_ASLPP_FLAGS    = $(DSC_PLTPKG_FEATURE_BUILD_OPTIONS)
MSFT:  *_*_X64_ASLCC_FLAGS    = $(DSC_PLTPKG_FEATURE_BUILD_OPTIONS)


